/**
* \file: am_api_mutex.c
*
* \version: $Id:$
*
* \release: $Name:$
*
* \component: automounter
*
* \author: Marko Hoyer / ADIT / SWGII / mhoyer@de.adit-jv.com
*
* \copyright (c) 2010, 2011 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
*
***********************************************************************/
#include <pthread.h>
#include <sys/syscall.h>
#include <unistd.h>
#include <stdio.h>

#include "am_api_mutex.h"
//------------------------------------- private attributes ------------------------------------------------------------
static pthread_mutex_t working_in_library_mutex = PTHREAD_MUTEX_INITIALIZER;

static pthread_mutex_t event_dispatcher_mutex = PTHREAD_MUTEX_INITIALIZER;

static pid_t thread_in_dispatcher_mutex_id=-1;

//--- sorry lin(t) forces me to do it a bit more complicated ;) ---
typedef int (*mutex_func_ptr_t)(pthread_mutex_t *mutex);

static const mutex_func_ptr_t __princess_lint_mutex_lock = pthread_mutex_lock;

static const mutex_func_ptr_t __princess_lint_mutex_unlock = pthread_mutex_unlock;

//---------------------------------------------------------------------------------------------------------------------

//------------------------------------- public member definition ------------------------------------------------------
void am_api_mutex_entering_library(void)
{
	__princess_lint_mutex_lock(&working_in_library_mutex);
}

void am_api_mutex_leaving_library(void)
{
	__princess_lint_mutex_unlock(&working_in_library_mutex);
}

error_code_t am_api_mutex_entering_event_dispatcher(void)
{

	pid_t thread_in_here_id;
	thread_in_here_id=syscall(SYS_gettid);

	//this functionality finds out if we are entering the mutex lock function twice with the same thread. We need to
	//catch this before we are locking the mutex since depending on the situation different actions need to be taken.
	//Please note: thread_in_dispatcher_mutex_id might be changed by other while we are in this function. However, the
	//following if statement checks only if we are already in the mutex. While we are in the mutex, no one else is able
	//to be in the mutex as well so no one can change the value to its own id.
	if (thread_in_here_id == thread_in_dispatcher_mutex_id)
		return RESULT_INVALID;

	__princess_lint_mutex_lock(&event_dispatcher_mutex);
	thread_in_dispatcher_mutex_id=thread_in_here_id;
	return RESULT_OK;
}

void am_api_mutex_leaving_event_dispatcher(void)
{
	//we are leaving, so we are removing our id from thread_in_dispatcher_mutex_id so that we are able to enter again
	//next time.
	thread_in_dispatcher_mutex_id=-1;
	__princess_lint_mutex_unlock(&event_dispatcher_mutex);
}
//---------------------------------------------------------------------------------------------------------------------
